﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

namespace hive.adkit.daro
{
    
    public enum BannerPosition {
        Top = 0,
        Bottom = 1
    }

    public class HIVEAdKit : MonoBehaviour
    {

        private static string TAG = "HIVEAdKit::";
        public static string appDomain;
        public static Action<bool> onAdKitInitializeCompleted = null;
        public static Action<bool> onAdKitConsentUICompleted = null;

        public static HIVEAdKit Instance { get; private set; }
        void Awake()
        {
            if (Instance == null)
            {
                Instance = this;
                DontDestroyOnLoad(gameObject);
                GameObject adKitManager = new GameObject("AdKitCallbackManager");
                adKitManager.AddComponent<AdKitCallbackManager>();
                DontDestroyOnLoad(adKitManager);
            }
            else
                Destroy(this);
        }

        void OnDestroy()
        {
            if (Instance == this)
                Instance = null;
        }

        public static void InitPlugin() {
			GameObject callbackManager = new GameObject("AdKitCallbackManager");
        	callbackManager.AddComponent<AdKitCallbackManager>();
        	DontDestroyOnLoad(callbackManager);// Hive AdKit callback
		}

        /*  
         *  사용자의 위치 및 동의 여부를 확인하여 동의 UI 노출이 필요한 경우
         *  @param appDomain        ADOP AppDomain ADOP초기화 필수값 발급받은 값을 사용해주세요.
         *  @param debugState       ADOP debug ADOP 디버그 상태로 로그를 출력을 활성화하는 경우 true로 설정해주세요.
         *                          GDPR debug Mode 유럽 외 지역에서 Consent UI를 확인할 경우 true 로 설정해주세요.
         *  @param testGDPRDeviceId GDPR debug Mode 일때 테스트할 기기 식별자를 입력해주세요.
         *  iOS: <UMP SDK> To enable debug mode for this device, set: UMPDebugSettings.testDeviceIdentifiers = @[ @"테스트 디바이스 고유 ID" ];
         *  AOS: UserMessagingPlatform: Use new ConsentDebugSettings.Builder().addTestDeviceHashedId("테스트 디바이스 해시 ID") to set this as a debug device.
         */
        public static void Initialize(Action<bool> onAdKitInitializeComplete)
        {
            AdKitBase.Initialize();
            AdKitCallbackManager.Instance.OnAdKitInitializeCallback(onAdKitInitializeComplete);
        }

        public static void ShowConsentUI(string noticeId, Action onShowConsentUIFinish)
        {
            AdKitBase.ShowConsentUI(noticeId);
            AdKitCallbackManager.Instance.OnShowConsentUIFinishCallback(onShowConsentUIFinish);
        }

        public static void SetAdditionalInfo(string addtionalInfo)
        {
            AdKitBase.SetAdditionalInfo(addtionalInfo);
        }

        public static void SetLogEnable(bool isOn)
        {
            AdKitBase.SetLogEnable(isOn);
        }

        public class Interstitial
        {
            private AdKitInterstitial interstitialAd;

            private Interstitial(string unitId, EventHandlers eventHandlers)
            {
                interstitialAd = new AdKitInterstitial(unitId, eventHandlers);
            }

            ~Interstitial()
            {
                interstitialAd = null;
            }

            public string AdTypeName()
            {
                return "Interstitial";
            }

            public static Interstitial Initialize(string unitId, EventHandlers eventHandlers = null)
            {
                Debug.Log(TAG + "Initialize");
                Interstitial ad = new Interstitial(unitId, eventHandlers);
                return ad;
            }

            public static void Load(Interstitial ad, string adPlacementInfo = "")
            {
                if (ad != null && ad.interstitialAd != null && !ad.interstitialAd.IsLoaded())
                {
                    ad.interstitialAd.Load(adPlacementInfo);
                }
            }

            public static bool IsLoaded(Interstitial ad)
            {
                if (ad != null && ad.interstitialAd != null)
                {
                    return ad.interstitialAd.IsLoaded();
                }
                return false;
            }

            public static void Show(Interstitial ad, string adPlacementInfo = "")
            {
                if (ad != null && ad.interstitialAd != null && ad.interstitialAd.IsLoaded())
                {
                    ad.interstitialAd.Show(adPlacementInfo);
                }
            }
            
            public static void Destroy(Interstitial ad)
            {
                if (ad != null && ad.interstitialAd != null)
                {
                    ad.interstitialAd.Destroy();
                }
            }
        }


        public class Banner
        {
            private AdKitBanner bannerAd;

            private Banner(string unitId, BannerPosition bannerPosition, EventHandlers eventHandlers)
            {
                bannerAd = new AdKitBanner(unitId, bannerPosition, eventHandlers);
            }

            ~Banner()
            {
                if(bannerAd != null) {
                    bannerAd = null;
                }
            }

            public string AdTypeName()
            {
                return "Banner";
            }

            public static Banner Initialize(string unitId, BannerPosition bannerPosition, EventHandlers eventHandlers = null)
            {
                Debug.Log(TAG + "Initialize");
                Banner ad = new Banner(unitId, bannerPosition, eventHandlers);
                return ad;
            }

            public static void Load(Banner ad, string adPlacementInfo = "")
            {
                if( ad != null && ad.bannerAd != null ) {
                    ad.bannerAd.Load(adPlacementInfo);
                }
            }

            public static void Destroy(Banner ad)
            {
                if( ad != null && ad.bannerAd != null ) {
                    ad.bannerAd.Destroy();
                }
            }
        }

        public class RewardVideo
        {
            private AdKitRewarded rewardedAd;

            private RewardVideo(string unitId, EventHandlers eventHandlers)
            {
                rewardedAd = new AdKitRewarded(unitId, eventHandlers);
            }

            ~RewardVideo()
            {
                rewardedAd = null;
            }

            public string AdTypeName()
            {
                return "RewardVideo";
            }

            public static RewardVideo Initialize(string unitId, EventHandlers eventHandlers = null)
            {
                Debug.Log(TAG + "Initialize");
                RewardVideo ad = new RewardVideo(unitId, eventHandlers);
                return ad;
            }

            public static void Load(RewardVideo ad, string adPlacementInfo = "")
            {
                if (ad != null && ad.rewardedAd != null && !ad.rewardedAd.IsLoaded())
                {
                    ad.rewardedAd.Load(adPlacementInfo);
                }
            }

            public static bool IsLoaded(RewardVideo ad)
            {
                if (ad != null && ad.rewardedAd != null)
                {
                    return ad.rewardedAd.IsLoaded();
                }
                else
                    return false;
            }

            public static void Show(RewardVideo ad, string adPlacementInfo = "")
            {
                if (ad != null && ad.rewardedAd != null)
                {
                    ad.rewardedAd.Show(adPlacementInfo);
                }
            }
            
            public static void Destroy(RewardVideo ad)
            {
                if( ad != null && ad.rewardedAd != null ) {
                    ad.rewardedAd.Destroy();
                }
            }
        }
    }
}